/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.client.screen.basic;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.sixik.sdmshoprework.SDMShopClient;
import net.sixik.sdmshoprework.client.screen.basic.panel.AbstractShopEntriesPanel;
import net.sixik.sdmshoprework.client.screen.basic.panel.AbstractShopMoneyPanel;
import net.sixik.sdmshoprework.client.screen.basic.panel.AbstractShopTabPanel;
import net.sixik.sdmshoprework.client.screen.basic.widget.AbstractShopEntryButton;
import net.sixik.sdmshoprework.client.screen.legacy.createEntry.LegacyCreateEntryScreen;
import net.sixik.sdmshoprework.common.config.ConfigFile;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopTab;

public abstract class AbstractShopScreen
extends BaseScreen {
    public String searchField = "";
    public UUID selectedEntryID = null;
    public UUID selectedTabID = null;
    public AbstractShopEntriesPanel entriesPanel;
    public AbstractShopTabPanel tabsPanel;
    public AbstractShopMoneyPanel moneyPanel;
    public ShopTab selectedTab;
    public boolean isOpenCommand;

    public boolean drawDefaultBackground(PoseStack graphics) {
        return false;
    }

    public AbstractShopScreen(boolean isOpenCommand) {
        this.isOpenCommand = isOpenCommand;
        this.onConstruct();
    }

    public void onConstruct() {
        if (ShopBase.CLIENT.getShopTabs().isEmpty()) {
            this.selectedTab = null;
        } else {
            this.selectedTab = null;
            for (ShopTab shopTab : ShopBase.CLIENT.getShopTabs()) {
                if (shopTab.isLocked()) continue;
                this.selectedTab = shopTab;
                break;
            }
        }
    }

    public void openCreateScreen() {
        new LegacyCreateEntryScreen(this).openGui();
    }

    public void alignWidgets() {
        this.setProperties();
    }

    public void setProperties() {
    }

    public void setSelectedTab(ShopTab shopTab) {
        this.selectedTab = shopTab;
        this.selectedEntryID = null;
    }

    public boolean onInit() {
        if (ConfigFile.CLIENT.disableKeyBind && !this.isOpenCommand) {
            return false;
        }
        this.setWidth(this.getScreen().m_85445_() * 4 / 5);
        this.setHeight(this.getScreen().m_85446_() * 4 / 5);
        this.openContextMenu(null);
        return true;
    }

    public static void refreshIfOpen() {
        ScreenWrapper w;
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ScreenWrapper && (screen = (w = (ScreenWrapper)screen).getGui()) instanceof AbstractShopScreen) {
            AbstractShopScreen mts = (AbstractShopScreen)screen;
            mts.refreshWidgets();
        }
    }

    public abstract void addEntriesButtons();

    public abstract void addTabsButtons();

    public abstract void calculatePositions(List<AbstractShopEntryButton> var1);

    public void drawBackground(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
        SDMShopClient.getTheme().draw(graphics, x, y, w, h);
    }
}

